﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Brand
{
    public partial class EditBrands : System.Web.UI.Page
    {
        private ProductBrand myBrand;

        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdProductBrandID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowProductBrand();
                }
            }
        }

        private void ShowProductBrand()
        {
            myBrand = ProductBrandBL.GetItem(Guid.Parse(hdProductBrandID.Value.Trim()), string.Empty);
            if (myBrand != null)
            {
                hdProductBrandID.Value = myBrand.UniqueID.ToString();
                txtBrandName.Text = myBrand.BrandName;
                txtSequenceNo.Text = myBrand.SequenceNo.ToString();
                chkIsActive.Checked = myBrand.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                myBrand = new ProductBrand();
                if (hdProductBrandID.Value.Trim().Length == 0)
                    myBrand.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    myBrand.Mode = GlobalConfigurations.Mode.Update;
                    myBrand.UniqueID = Guid.Parse(hdProductBrandID.Value.Trim());
                }

                myBrand.BrandName = txtBrandName.Text.Trim();
                myBrand.SequenceNo = int.Parse(txtSequenceNo.Text.Trim());
                myBrand.IsActive = chkIsActive.Checked;
                myBrand.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (ProductBrandBL.Save(myBrand))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Product Brand details has been saved successfully.<br>Do you want to add another Product Brand?", this.ResolveClientUrl("~/Admin/Masters/Brand/Brands.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Masters/Brand/Brands.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtBrandName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtBrandName.ClientID + "', 'Please enter Product Brand Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtSequenceNo.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtSequenceNo.ClientID + "', 'Please enter valid Display Order.'); ", true);
                return false;
            }

            return true;
        }
    }
}